% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEggs.R
\name{plotEggs}
\alias{plotEggs}
\title{Plot for the Number of Eggs Laid per Female}
\usage{
plotEggs(object)
}
\arguments{
\item{object}{\code{object} accepts 2 classes of objects:
\itemize{
\item{An object inheriting from \code{\link[=lifertable]{lifertable()}},
representing the Life and Fertility Table.}
\item{An object of class \code{lifertableTotEggs} inherited from
\code{\link[=lifertable]{lifertable()}}. This is the object that
displays the total number of eggs laid per female.}
}}
}
\value{
Returns an object of \code{\link[base:class]{class}} c("gg", "ggplot").
}
\description{
This function generates a Plot representing the number of Eggs Laid by
each Female throughout the entire experiment.
}
\examples{
## The main object will be created using the Insects database:
lft <- lifertable(ColumnFemale = Female,
                  ColumnAge = Age,
                  ColumnEggs = Eggs,
                  SexRate = Sexrate,
                  ColumnGroups = Group,
                  data = Insects,
                  TotalEggs = TRUE)

## Possible usage scenarios

## 1. Direct Usage of the "lft" Object:
plotEggs(lft)

## 2. Assigning the component "TOTAL.EGGS" to an object:
TEggs <- lft$TOTAL.EGGS
plotEggs(TEggs)

## 3. Direct usage of the component:
plotEggs(lft$TOTAL.EGGS)


}
