% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffvariance.CI.R
\name{diffvariance.CI}
\alias{diffvariance.CI}
\title{Confidence Interval for the Ratio Between the Variances of Two Normal Populations}
\usage{
diffvariance.CI(x1 = NULL, x2 = NULL, s1 = NULL, s2 = NULL,
  sc1 = NULL, sc2 = NULL, smu1 = NULL, smu2 = NULL, mu1 = NULL,
  mu2 = NULL, n1 = NULL, n2 = NULL, conf.level)
}
\arguments{
\item{x1}{a numeric vector containing the sample of one population.}

\item{x2}{a numeric vector containing the sample of the other population.}

\item{s1}{a single numeric value corresponding with the sample standard deviation of the first sample.}

\item{s2}{a single numeric value corresponding with the sample standard deviation of the second sample.}

\item{sc1}{a single numeric value corresponding with the cuasi-standard deviation of the first sample.}

\item{sc2}{a single numeric value corresponding with the cuasi-standard deviation of the second sample.}

\item{smu1}{if known, a single numeric value corresponding with the estimation of the standard deviation of the first sample.}

\item{smu2}{if known, a single numeric value corresponding with the estimation of the standard deviation of the second sample.}

\item{mu1}{if known, a single numeric  corresponding with the mean of one population.}

\item{mu2}{if known, a single numeric value corresponding with the mean of the other population.}

\item{n1}{a single positive integer corresponding with the size of one sample.}

\item{n2}{a single positive integer corresponding with the size of the other sample.}

\item{conf.level}{is the confidence level of the interval; must be a value in (0,1).}
}
\value{
A list containing the following components:
\item{var.estimate}{numeric value corresponding with the ratio of cuasi-variances for unknown population mean, and the ratio of the sample variances for known population mean.}
\item{sd.estimate}{numeric value corresponding with the ratio of cuasi-standard deviations for unknown population mean and the ratio of the sample standard deviations for known population mean.}
\item{CI.var}{a numeric vector of length two containing the lower and upper bounds of the confidence interval for the population variance.}
\item{CI.sd}{a numeric vector of length two containing the lower and upper bounds of the confidence interval for the population standard deviation.}
Independently on the user saving those values, the function provides a summary of the result on the console.
}
\description{
\code{diffvariance.CI} provides a pointwise estimation and a confidence interval for the ratio of Normal population variances in both scenarios: known and unknown population mean.
}
\details{
The formula interface is applicable when the user provides the sample and when the user provides the value of the sample characteristics (sample mean, cuasi-standard deviation or sample standard deviation, and sample size). Moreover, when mu1, smu1, mu2 or smu2 are provided, the function performs the procedure with known population means, and unknown in other case.
}
\examples{
#Given the samples with known population means
dat1=rnorm(20,mean=2,sd=1); dat2=rnorm(30,mean=3,sd=1)
diffvariance.CI(x1=dat1,x2=dat2,mu1=2,mu2=3,conf.level=0.95)

#Given the sample standard deviations with known population means
dat1=rnorm(20,mean=2,sd=1); dat2=rnorm(30,mean=3,sd=1)
smu1=Smu(dat1,mu=2);smu2=Smu(dat2,mu=3)
diffvariance.CI(smu1=smu1,smu2=smu2,n1=20,n2=30,conf.level=0.95)

#Given the samples with unknown population means
dat1=rnorm(20,mean=2,sd=1); dat2=rnorm(30,mean=3,sd=1)
diffvariance.CI(x1=dat1,x2=dat2,conf.level=0.95)

#Given the sample standard deviations with unknown population means
dat1=rnorm(20,mean=2,sd=1); dat2=rnorm(30,mean=3,sd=1)
diffvariance.CI(s1=(19/20)*sd(dat1),s2=(29/30)*sd(dat2),n1=20,n2=30,conf.level=0.95)

}
