% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2mu.R
\name{S2mu}
\alias{S2mu}
\title{Variance Estimator when the Population Mean is Known}
\usage{
S2mu(x, mu)
}
\arguments{
\item{x}{a numeric vector  containing the sample.}

\item{mu}{the population mean.}
}
\value{
A single numerical value corresponding with the variance estimation when the population mean is known.
}
\description{
\code{S2mu} computes a estimation of the variance, given a sample {x} with known population mean (denoted by \code{mu}).
}
\details{
Given \eqn{\{x_1,\ldots,x_n\}} a sample of a random variable, the variance estimator
when the population mean (denoted by \eqn{\mu}) is known can be computed as
\eqn{S^2_\mu=\frac{1}{n}\sum_{i=1}^n (x_i-\mu)^2}.
}
\examples{
x=rnorm(20)
S2mu(x,mu=0)
}
