% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_survival_model.R
\name{fit_survival_model}
\alias{fit_survival_model}
\title{Fit a survival sub-model}
\usage{
fit_survival_model(
  data,
  individual_id,
  cv_name = NA,
  covariates,
  event_time,
  event_status,
  survival_submodel = c("standard_cox", "cause_specific", "fine_gray"),
  x_hor
)
}
\arguments{
\item{data}{Data frame containing covariates and time-to-event data, one row for each individual.}

\item{individual_id}{Character string specifying the column name in \code{data} which contains the individual identifiers}

\item{cv_name}{Character string specifying the column name in \code{data} that indicates cross-validation fold. If no cross-validation is needed, set this parameter to \code{NA}.}

\item{covariates}{Vector of character strings specifying the column names in \code{data_long}
which correspond to the covariates}

\item{event_time}{Character string specifying the column name in \code{data} which contains the event time}

\item{event_status}{Character string specifying the column name in \code{data} which contains the event status (where 0=censoring, 1=event of interest, if there are competing events these are labelled 2 or above). Events at time x_hor should be labelled censored.}

\item{survival_submodel}{Character string specifying which survival submodel to
use. Three options: the standard Cox model i.e. no competing risks (\code{"standard_cox"}),
the cause-specific regression model (\code{"cause_specific"}), or the Fine Gray
regression model (\code{"fine_gray"})}

\item{x_hor}{Numeric specifying the horizon time(s)}
}
\value{
List containing \code{data_survival} and \code{model_survival}

\code{data_survival} contains the predicted risk of event by the horizon time \code{x_hor}.

\code{model_survival} contains the outputs from the function used to fit the survival submodel, including the estimated parameters of the model.
For a model using cross-validation, \code{model_survival} contains a list of outputs with each
element in the list corresponding to a different cross-validation fold.
}
\description{
This function is a helper function for \code{fit_LOCF_landmark_model} and \code{fit_LME_landmark_model}.
}
\details{
For the survival submodel, there are three choices of model:
\itemize{
\item the standard Cox model, this is a wrapper function for \code{coxph} from the package \code{survival}
\item the cause-specific model, this is a wrapper function for \code{CSC} from package \code{riskRegression}
\item the Fine Gray model, this is a wrapper function for \code{FGR} from package \code{riskRegression}
}

The latter two models estimate the probability of the event of interest in the presence of competing events.

For both the c-index and Brier score calculations, inverse probability censoring weighting (IPCW) is used to create weights which account for the occurrence of censoring. The censoring model assumes for this function is the Kaplan Meier model, i.e. censoring occurs independently of covariates.
}
\author{
Isobel Barrott \email{isobel.barrott@gmail.com}
}
