% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_SpatialUnitSize.R
\name{calculate_SpatialUnitSize}
\alias{calculate_SpatialUnitSize}
\title{Number of grid cells covered by enlarged spatial units}
\usage{
calculate_SpatialUnitSize(aggregation_step, square = FALSE)
}
\arguments{
\item{aggregation_step}{A numeric vector of length one containing a
non-negative number. This number expresses the size of the spatial units for
which calculation of compositional diversity and associatum is required. The
size is measured by the number of rows of grid cells around the central grid
cell, where 0 means the original cell without enlargement. Fraction number
can be also set as input. In this case, the following step's spatial unit
minus grid cells touching the vertices are used as spatial base units. Note,
in the case of hexagonal grid, steps falling in the interval ]0,1[ cannot be
evaluated. Negative, non-finite and missing values are ignored with warning.}

\item{square}{A logical vector of length one. Should be \code{TRUE} if square grid,
\code{FALSE}, if is hexagonal grid is used as the basis of calculation.}
}
\value{
A numeric vector of length one.
}
\description{
Calculate the number of grid cells covered by the radially enlarged spatial
units.
}
\examples{
calculate_SpatialUnitSize(aggregation_step = 0, square = TRUE)

foo = c()
for(i in c(0, 0.5, 1, 1.5, 2, 3))
  foo = c(foo, calculate_SpatialUnitSize(aggregation_step = i, square = TRUE))
foo

vapply(c(0, 1, 1.5, 2, 3), FUN = function(i){
  calculate_SpatialUnitSize(aggregation_step = i, square = FALSE)},
  FUN.VALUE = numeric(length = 1))

}
