% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{map_ontology}
\alias{map_ontology}
\title{Map terms to biomedical ontologies}
\usage{
map_ontology(
  terms,
  ontology = c("mesh", "umls"),
  api_key = NULL,
  fuzzy_match = FALSE,
  similarity_threshold = 0.8,
  mesh_query = NULL,
  semantic_types = NULL,
  dictionary_type = "disease"
)
}
\arguments{
\item{terms}{Character vector of terms to map}

\item{ontology}{Character string. The ontology to use: "mesh" or "umls"}

\item{api_key}{UMLS API key (required if ontology = "umls")}

\item{fuzzy_match}{Logical. If TRUE, allows fuzzy matching of terms}

\item{similarity_threshold}{Numeric between 0 and 1. Minimum similarity for fuzzy matching}

\item{mesh_query}{Additional query to filter MeSH terms (only if ontology = "mesh")}

\item{semantic_types}{Vector of semantic types to filter UMLS results}

\item{dictionary_type}{Type of dictionary to use ("disease", "drug", "gene", etc.)}
}
\value{
A data frame with mapped terms and ontology identifiers
}
\description{
This function maps terms to standard biomedical ontologies like MeSH or UMLS.
}
