% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l2e_regression_sparse_dist.R
\name{l2e_regression_sparse_dist}
\alias{l2e_regression_sparse_dist}
\title{L2E sparse regression with distance penalization}
\usage{
l2e_regression_sparse_dist(
  y,
  X,
  beta,
  tau,
  k,
  rho = 1,
  stepsize = 0.9,
  sigma = 0.5,
  max_iter = 100,
  tol = 1e-04,
  Show.Time = TRUE
)
}
\arguments{
\item{y}{Response vector}

\item{X}{Design matrix}

\item{beta}{Initial vector of regression coefficients}

\item{tau}{Initial precision estimate}

\item{k}{The number of nonzero entries in the estimated coefficients}

\item{rho}{The parameter in the proximal distance algorithm}

\item{stepsize}{The stepsize parameter for the MM algorithm (0, 1)}

\item{sigma}{The halving parameter sigma (0, 1)}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Relative tolerance}

\item{Show.Time}{Report the computing time}
}
\description{
\code{l2e_regression_sparse_dist} performs robust sparse regression under the L2 criterion with the distance penalty
}
