% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solveMatrix.R
\name{solMat}
\alias{solMat}
\title{Generate the inverse of the crossprod matrix}
\usage{
solMat(n, q, A)
}
\arguments{
\item{n}{The number of data points}

\item{q}{The order of the difference, 0 or 1}

\item{A}{The set of indicators, a subset of \eqn{\{1,2,3,\dots,n\}}}
}
\value{
The inverse matrix of \eqn{(\boldsymbol{X}^{(q+1)}_A)^T \boldsymbol{X}^{(q+1)}_A} for the cases where \eqn{q=} 0 or 1.
}
\description{
Generate the inverse matrix of \eqn{(\boldsymbol{X}^{(q+1)}_A)^T \boldsymbol{X}^{(q+1)}_A} for the cases where \eqn{q=0} or \eqn{q=1}, commonly employed in splicing algorithms. Note that an explicit solution exists for the inverse when \eqn{q=0}, but not when \eqn{q=1}.
}
\examples{
Mat1 <- XMat(n = 10, q = 0)
A1 = c(1,2,5,8)
mat1 = as.matrix(Mat1[,A1])
S1 <- solMat(n = 10, q = 0, A = A1)
print(S1)
print(round(S1\%*\%t(mat1)\%*\%mat1,10))

Mat2 <- XMat(n = 15, q = 1)
A2 = c(1,3,8,10,15)
mat2 = as.matrix(Mat2[,A2])
S2 <- solMat(n = 15, q = 1, A = A2)
print(S2)
print(round(S2\%*\%t(mat2)\%*\%mat2,10))
}
