% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.L0TFinvfix}
\alias{print.L0TFinvfix}
\alias{print.L0TFinvopt}
\title{Print L0TFinvfix or L0TFinvopt object}
\usage{
\method{print}{L0TFinvfix}(x, ...)

\method{print}{L0TFinvopt}(x, ...)
}
\arguments{
\item{x}{The output of L0TFinvfix or L0TFinvopt}

\item{...}{ignore}
}
\value{
Estimated parameters and information criteria for L0TFinvfix and L0TFinvopt across an increasing number of change points
}
\description{
Prints a summary of L0TFinvfix or L0TFinvopt
}
\examples{
library(ggplot2)

tau = c(0.1, 0.3, 0.4, 0.7, 0.85)
h = c(-1, 5, 3, 0, -1, 2)
BlocksData <- SimuBlocksInv(n = 500, sigma = 0.2, seed = 50, tau = tau ,h = h)
res <- L0TFinv.opt(y=BlocksData$y, kmax=10, q=0, first=0.01, last=1, penalty="bic")
print(res)
coef(res,k=res$kopt)
plot(res,type="yhat")
plot(res,type="bic")

tau1 = c(0.1, 0.3, 0.4, 0.7, 0.85)
h1 = c(-1, 5, 3, 0, -1, 2)
a0 = -10
WaveData <- SimuWaveInv(n = 2000, sigma = 0.1, seed = 50, tau = tau1, h = h1, a0 = a0)
res1 <- L0TFinv.fix(y=WaveData$y, k=20, q=1, first=0, last=0.99)
print(res1)
coef(res1,k=5)
plot(res1,type="yhat",k=5)
plot(res1,type="mse")

}
