#' CD4 cell counts
#'
#' A dataset containing the logarithm of CD4 cell counts for 190 patients with AIDS from June 1997 to January 2002. The data come from a human immunodeficiency virus (HIV) study by Wohl et al. (2005) and can be obtained from Cao et al. (2015).
#'
#' @format A data frame with 741 rows and 3 variables:
#' \describe{
#' \item{PATIENT}{Patient ID.}
#' \item{CD4OBS}{Logarithm of CD4 cell counts.}
#' \item{CD4DATE}{Day of measurement.}
#' }
#' @references
#' \cite{David A. Wohl, Donglin Zeng, Paul Stewart, Nicolas Glomb, Timothy Alcorn, Suzanne Jones, Jean Handy, Susan Fiscus, Adriana Weinberg, Deepthiman Gowda, and Charles van der Horst (2005). "Cytomegalovirus viremia, mortality, and end-organ disease among patients with aids receiving potent antiretroviral therapies." Journal of Acquired Immune Deficiency Syndromes, 38(5):538-544.}
#'
#' \cite{Hongyuan Cao, Donglin Zeng, and Jason P. Fine (2015). "Regression analysis of sparse asynchronous longitudinal data." Journal of The Royal Statistical Society Series B-statistical Methodology, 77(4):755-776.}
"CD4"
