% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{juliaEval}
\alias{juliaEval}
\title{Evaluate a Julia expression}
\usage{
juliaEval(expr)
}
\arguments{
\item{expr}{Julia code, given as a one-element character vector}
}
\value{
The value returned from Julia, translated to an R data structure.
If Julia returns \code{nothing}, an invisible \code{NULL} is returned.
This is also the case if the last non-whitespace character of \code{expr}
is a semicolon.
}
\description{
This function evaluates Julia code, given as a string, in Julia,
and translates the result back to R.
}
\details{
If the code needs to use R variables, consider using \code{juliaLet}
instead.
}
\examples{
if (juliaSetupOk()) {
   juliaEval("1 + 2")
   juliaEval('using Random; Random.seed!(5);')

\dontrun{
   juliaEval('using Pkg; Pkg.add("BoltzmannMachines")')
}
}
\dontshow{
stopJulia()
}
}
