% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosscorr.R
\name{auto_corr}
\alias{auto_corr}
\alias{auto_corr_plot}
\title{Autocorrelation of MCMC samples}
\usage{
auto_corr(object, lags = 0:30, by_chain = TRUE, outcome = 1L,
  start = NULL, end = NULL, thin = NULL)

auto_corr_plot(object, lags = 0:30, by_chain = TRUE, outcome = 1L,
  start = NULL, end = NULL, thin = NULL)
}
\arguments{
\item{object}{an object of class JointAI}

\item{lags}{a numeric vector indicating the lags to consider}

\item{by_chain}{logical; should the autocorrelation be computed for each
chain separately?}

\item{outcome}{integer; index of the outcome model for which the
autocorrelation should be plotted}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}
}
\value{
a \code{matrix} or a \code{list} of \code{matrix} objects if \code{by_chain = TRUE}, or
a \code{ggplot()} object for \code{autocorr_plot()}.
}
\description{
This function obtains the autocorrelation of the MCMC samples in an JointAI
object via \code{coda::autocorr.diag()}. \code{autocorr_plot()} visualizes the results
using \strong{ggplot2}.
}
\examples{
fit <- lm_imp(y ~ C1 + C2 + B2, data = wideDF, n.iter = 200)
auto_corr(fit)
auto_corr_plot(fit)

}
