% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_specification.R
\name{predictor_spec}
\alias{predictor_spec}
\title{Specify how a single predictor should be used}
\usage{
predictor_spec(pred, first_day_only = TRUE)
}
\arguments{
\item{pred}{String indicating where to get predictor data. Can be one of:
\itemize{
\item A string in the \code{"pred"} column in the \code{\link{predictors}} table.
In this case, the predictor value passed to the containing
\code{\link{transition}}'s \code{fun} is the corresponding value of that
predictor in the table.
\item A string that matches at least one life stage name via regex. In this
case, the value passed to the containing \code{\link{transition}}'s \code{fun}
is the sum of the population sizes of all matched life stages.
}}

\item{first_day_only}{Boolean indicating whether to repeat the predictor data
value from the first day of a \code{\link{transition}} when evaluating it
(\code{TRUE} case), or to use the range of predictor data over the duration of a
transition (\code{FALSE} case). \code{FALSE} is only valid for \code{\link{transition}}s
with \code{"duration"} as the \code{transition_type}, because \code{"probability"} type
transitions only last one day. A value of \code{FALSE} also requires the \code{name}
parameter to be a value in the \code{\link{predictors}} table \code{"pred"}
column, not a tick life stage.}
}
\value{
a \code{predictor_spec} list-based object
}
\description{
Specify how a single predictor should be used
}
