% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{summaryVector}
\alias{summaryVector}
\title{Calculates statistic for the received vector.}
\usage{
summaryVector(vec)
}
\arguments{
\item{vec}{the vector to calculate the summary.}
}
\value{
a list with mean, standard deviation, maximum, minimum, 0.1\% and 99.9\% quantile and median of the received vector.
}
\description{
\code{summaryVector}. Calculates basic statistic of the received vector, like mean, standard deviation, maximum, minimum, 0.1\% and 99.9\% quantile and median.
}
\examples{
inputFileName<-system.file("testdata", "chen.csv", package="Irescale")
input<-loadFile(inputFileName)
distM<-calculateEuclideanDistance(input$data)
I<-calculateMoranI(distM = distM,varOfInterest = input$varOfInterest)
vI<-resamplingI(distM, input$varOfInterest)
statsVI<-summaryVector(vI)
}
