% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossdep_3series.R
\name{crossdep_3series}
\alias{crossdep_3series}
\title{Cross-dependence statistics for testing independence between the innovations of 3 series of same length}
\usage{
crossdep_3series(x, y, z, lag2, lag3)
}
\arguments{
\item{x}{Pseudo-observations (or residuals) of first series.}

\item{y}{Pseudo-observations (or residuals) of second series.}

\item{z}{Pseudo-observations (or residuals) of third series.}

\item{lag2}{Maximum number of lags around 0 for pairs of series.}

\item{lag3}{Maximum number of lags around 0 for the three series.}
}
\value{
\item{stat}{Cross-dependences for all lags  and for all subsets}

\item{H}{Sum of squares of cross-correlations for all subsets}

\item{pvalue}{P-value of LB for all subsets and H}

\item{n}{length of the time series}
}
\description{
This function computes the cross-dependence for Spearman, van der Waerden and Savage dependence measures, for all lags = -lag2, .. lag2, for all pairs, and for pair of lags = (-lag3,-lag3),...(lag3,lag3) for the three series.
}
\examples{
#Romano-Siegel's example #
data(romano_ex)
outr = crossdep_3series(romano_ex$x,romano_ex$y,romano_ex$z,5,2)
CrossCorrelogram(outr$spearman$out123,"Savage for {1,2,3}",rot=90)

}
\references{
Duchesne, Ghoudi & Remillard  (2012). On Testing for independence between the innovations of several time series. CJS, vol. 40, 447-479.

Nasri & Remillard  (2024). Tests of independence and randomness for arbitrary data using copula-based covariances. JMVA, vol. 201, 105273.
}
