% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice_impute_gamlss.R
\name{mice.impute.gamlss}
\alias{mice.impute.gamlss}
\alias{mice.impute.gamlssNO}
\alias{mice.impute.gamlssBI}
\alias{mice.impute.gamlssJSU}
\alias{mice.impute.gamlssPO}
\alias{mice.impute.gamlssTF}
\alias{mice.impute.gamlssGA}
\alias{mice.impute.gamlssZIBI}
\alias{mice.impute.gamlssZIP}
\alias{fit.gamlss}
\title{Multiple Imputation with Generalized Additive Models for Location,
Scale, and Shape.}
\usage{
mice.impute.gamlss(y, ry, x, family = NO, n.ind.par = 2,
  fitted.gam = NULL, gam.mod = list(type = "pb"), EV = TRUE, ...)

mice.impute.gamlssNO(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssBI(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssJSU(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssPO(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssTF(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssGA(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssZIBI(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

mice.impute.gamlssZIP(y, ry, x, fitted.gam = NULL, EV = TRUE, ...)

fit.gamlss(y, ry, x, family = NO, n.ind.par = 2, gam.mod = list(type
  = "pb"), ...)
}
\arguments{
\item{y}{Numeric vector with incomplete data.}

\item{ry}{Response pattern of 'y' ('TRUE'=observed,
'FALSE'=missing).}

\item{x}{Design matrix with 'length(y)' rows and 'p' columns
containing complete covariates.}

\item{family}{Distribution family to be used by GAMLSS. It defaults
to NO but a range of families can be defined by calling the
corresponding "gamlssFAMILY" method.}

\item{n.ind.par}{Number of parameters from the distribution family
to be individually estimated.}

\item{fitted.gam}{A predefined bootstrap gamlss method returned by
\code{fit.gamlss}. Mice by default refits the model with each
imputation. The parameter is here for a future faster modified
mice function.}

\item{gam.mod}{list with the parameters of the GAMLSS imputation
model.}

\item{EV}{Logical value to determine whether to correct or not
extreme imputed values. This can arise due to too much
flexibility of the gamlss model.}

\item{...}{extra arguments for the control of the gamlss fitting
function}
}
\value{
Numeric vector with imputed values for missing \code{y}
  values
}
\description{
Imputes univariate missing data using a generalized
  model for location, scale and shape.
}
\details{
Imputation of \code{y} using generalized additive models
  for location, scale, and shape. A model is fitted with the
  observed part of the data set. Then a bootstrap sample is
  generated and used to refit the model and generate imputations.

  The function \code{fit.gamlss} handles the fitting and the
  bootstrap and returns a method to generated imputations.

  Being gamlss a flexible non parametric method, there may be
  problems with the fitting and imputation depending on the sample
  size. The imputation functions try to handle anomalies
  automatically, but results should be still inspected.
}
\examples{

require(lattice)
# Create the imputed data sets

predMat <- matrix(rep(0,25), ncol = 5)
predMat[4,1] <- 1
predMat[4,5] <- 1
predMat[2,1] <- 1
predMat[2,5] <- 1
predMat[2,4] <- 1
predMat[3,1] <- 1
predMat[3,5] <- 1
predMat[3,4] <- 1
predMat[3,2] <- 1
imputed.sets <- mice(sample.data, m = 2,
                     method = c("", "gamlssPO",
                                "gamlss", "gamlssBI", ""),
                     visitSequence = "monotone",
                     predictorMatrix = predMat,
                     maxit = 1, seed = 973,
                     n.cyc = 1, bf.cyc = 1,
                     cyc = 1)

fit <- with(imputed.sets, lm(y ~ X.1 + X.2 + X.3 + X.4))
summary(pool(fit))

stripplot(imputed.sets)

}
\references{
de Jong, R., van Buuren, S. & Spiess, M. (2016)
  Multiple Imputation of Predictor Variables Using Generalized
  Additive Models. Communications in Statistics -- Simulation and
  Computation, 45(3), 968--985.

de Jong, Roel. (2012). “Robust Multiple Imputation.” Universität
Hamburg. \url{http://ediss.sub.uni-hamburg.de/volltexte/2012/5971/}.

Rigby, R. A., and Stasinopoulos,
  D. M. (2005). Generalized Additive Models for Location, Scale and
  Shape. Journal of the Royal Statistical Society: Series C
  (Applied Statistics) 54 (3): 507–54.
}
\author{
Daniel Salfran \email{daniel.salfran@uni-hamburg.de}
}
