% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPICbetweentot.R
\name{calcPICbetweentot}
\alias{calcPICbetweentot}
\title{Calculates potential of identity coding (PIC, variant=PICbetweentot)}
\usage{
calcPICbetweentot(df)
}
\arguments{
\item{df}{A data frame with the first column indicating individual identity.}
}
\value{
Numeric vector with PIC values for each variable in \code{df}.
}
\description{
This function calculates Potential of individual coding for all variables
within the dataset. \cr\cr \strong{Reference:} Robisson, P. (1992). Roles of
pitch and duration in the discrimination of the mate's call in the King
penguin Aptenodytes patagonicus. Bioacoustics, 4, 25-36. \cr\cr
}
\examples{
calcPICbetweentot(ANmodulation)

}
\seealso{
Other individual identity metrics: \code{\link{calcDS}},
  \code{\link{calcF}}, \code{\link{calcHM}},
  \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHSvarcomp}}, \code{\link{calcHS}},
  \code{\link{calcMI}}, \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPIC}}
}
\concept{individual identity metrics}
