% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiGarrote.R
\name{predict.HiGarrote}
\alias{predict.HiGarrote}
\title{Make Predictions from a "HiGarrote" Object}
\usage{
\method{predict}{HiGarrote}(object, new_D, ...)
}
\arguments{
\item{object}{An HiGarrote object.}

\item{new_D}{A new design matrix where predictions are to be made.}

\item{...}{Additional arguments passed to `predict`. Not used in this function.}
}
\value{
The function returns a list with:
\describe{
\item{\code{new_U}}{A model matrix of \code{new_D}.}
\item{\code{prediction_nng}}{Predictions for \code{new_D}. The coefficients of the predictive equation are based on nonnegative garrote estimates.}
\item{\code{prediction_lm}}{Predictions for \code{new_D}. The coefficients of the predictive equation are estimated via ordinary least squares.}
}
}
\description{
This function makes predictions from a linear model constructed using the important effects selected by \code{HiGarrote}.
}
\examples{
# Cast fatigue experiment
data(cast_fatigue)
X <- cast_fatigue[1:10,1:7]
y <- cast_fatigue[1:10,8]
fit_Hi <- HiGarrote::HiGarrote(X, y)

# make predictions
new_D <- cast_fatigue[11:12,1:7]
pred_Hi <- predict(fit_Hi, new_D)
}
