% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getContactProbability}
\alias{getContactProbability}
\title{Contact probability}
\usage{
getContactProbability(
  tab,
  farthest = 2000000,
  resol = 10000,
  prob,
  n_cores = NULL
)
}
\arguments{
\item{tab}{Output from getContactFrequency function.}

\item{farthest}{Maximum 1-D distance to search. Default=2Mb}

\item{resol}{Hi-C resolution for test. Default = 10000}

\item{prob}{Significance cutoff for negative binomial distribution. Default =0.975}

\item{n_cores}{The number of cores used for parallel computing. If set as NULL, n_cores is automatically set to the number of cores in the computer if it is not exceed 30. If it is more than 30, it is set as 30. Default = NULL}
}
\value{
A \code{list} containing three objects: \code{AREA}, \code{original}, and \code{len1}, representing the statistical significance of each chromatin interaction pair.
}
\description{
It estimates contact probability based on the distance of a pair of a loci.
}
\details{
Get Contact probablity
}
\examples{
# This example might take a long time to run, so we wrap it in donttest{}
\donttest{
myhic = system.file('extdata','example.hic',package = 'HiCocietyExample')
mydf=getContactFrequency(myhic, 19, 5000);
myprob=getContactProbability(mydf,farthest=2000000, resol=5000,prob=0.975,
n_cores=2);
}
}
\author{
Sora Yoon, PhD
}
