% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HhP.reg.R
\name{HhP.reg}
\alias{HhP.reg}
\title{Hierarchical Heterogeneity Regression Analysis.}
\usage{
HhP.reg(lambda, whole.data, n, q, p, beta.init,
               merge.all=FALSE, trace=FALSE, selection.sub=FALSE)
}
\arguments{
\item{lambda}{The sequences of the tuning parameters (lambda1 and lambda2).}

\item{whole.data}{The input data analyzed (a list including the response and design matrix).}

\item{n}{The sample size.}

\item{q}{The dimension of type 1 features.}

\item{p}{The dimension of type 2 features.}

\item{beta.init}{The Initial values of regression coefficients.}

\item{merge.all}{the logical variable, the default is F.}

\item{trace}{the logical variable, whether or not to output the number of identified subgroups during the search for parameters.}

\item{selection.sub}{the logical variable, the default is F.}
}
\value{
A result list.
}
\description{
The main function for Transfer learning for tensor graphical models.
}
\examples{
\donttest{
library(HhP)
library(Matrix)
library(MASS)
library(fmrs)
data(example.data.reg)
n = example.data.reg$n
q = example.data.reg$q
p = example.data.reg$p

beta.init.list  =  gen_int_beta(n, p, q, example.data.reg)
beta.init  =  beta.init.list$beta.init
lambda  =  genelambda.obo()
result  =  HhP.reg(lambda, example.data.reg, n, q, p, beta.init)
index.list  =  evaluation.sum(n,q,p, result$admmres, result$abic.n,
               result$admmres2, example.data.reg$Beta0, result$bic.var)
index.list$err.s
}


}
\references{
Mingyang Ren, Qingzhao Zhang, Sanguo Zhang, Tingyan Zhong, Jian Huang, Shuangge Ma. 2022. Hierarchical Cancer Heterogeneity Analysis Based On Histopathological Imaging Features. Biometrics, <DOI: 10.1111/biom.13544>.
}
\author{
Mingyang Ren, Qingzhao Zhang, Sanguo Zhang, Tingyan Zhong, Jian Huang, Shuangge Ma. Maintainer: Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
