% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{hapiIdentifyCV}
\alias{hapiIdentifyCV}
\title{Indentify crossovers in gamete cells}
\usage{
hapiIdentifyCV(hap, gmt, hmm = NULL)
}
\arguments{
\item{hap}{a dataframe of the two haplotypes}

\item{gmt}{a dataframe of genotype data of gamete cells}

\item{hmm}{a list containing probabilities of a HMM. Default is \code{NULL}}
}
\value{
a dataframe containing crossover information in each gamete cell
}
\description{
Indentify crossovers in gamete cells
}
\examples{
ref <- sample(c('A','T'),500, replace=TRUE)
alt <- sample(c('C','G'),500, replace=TRUE)

hap <- data.frame(hap1=ref, hap2=alt, stringsAsFactors = FALSE)
rownames(hap) <- seq_len(500)

gmt <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
    gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
    stringsAsFactors = FALSE)
    
cvOutput <- hapiIdentifyCV(hap=hap, gmt=gmt)
}
\author{
Ruidong Li
}
