% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_pre_processing_functions.R
\name{estimate_leading_pc}
\alias{estimate_leading_pc}
\title{Estimate the leading principal component}
\usage{
estimate_leading_pc(control, pca_method = c("dense_pca", "sparse_pca"))
}
\arguments{
\item{control}{A matrix or data frame. Each row is a sample, and each column is a feature.}

\item{pca_method}{Character. PCA method to use. Options are \code{"dense_pca"} (default) or \code{"sparse_pca"}.}
}
\value{
A normalized numeric vector representing the leading principal component direction.
}
\description{
Estimates the leading principal component of the input matrix using dense or sparse PCA.
}
\details{
For low-dimensional settings (\eqn{\le} 30 features), the method automatically switches to dense PCA.
For sparse PCA, the function uses the \code{PMA::SPC.cv} cross-validation method.
}
\examples{
\dontrun{
X <- matrix(rnorm(100), nrow = 20)
estimate_leading_pc(X, pca_method = "dense_pca")
}

}
