% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_K_Fisher.R
\name{plot_K_Fisher}
\alias{plot_K_Fisher}
\title{Diagnostic plots explaining K-means clustering and Fisher's exact test carried out by HDStIM}
\usage{
plot_K_Fisher(mapped_data, path = NULL, verbose = FALSE)
}
\arguments{
\item{mapped_data}{Returned list from the \code{\link{HDStIM}} function.}

\item{path}{Path to the folder to save figures generated by this function NULL by default.}

\item{verbose}{Logical. To make function more verbose. Default is FALSE.}
}
\value{
A list of ggplot objects. If the path is not NULL, PNG files of the plots are saved in the specified folder.
}
\description{
Diagnostic plots explaining K-means clustering and Fisher's exact test carried out by HDStIM
}
\examples{
mapped_data <- HDStIM(chi11$expr_data, chi11$state_markers,
                  chi11$cluster_col, chi11$stim_label,
                  chi11$unstim_label, seed_val = 123, umap = FALSE, umap_cells = NULL,
                  verbose = FALSE)

pk <- plot_K_Fisher(mapped_data, path = NULL, verbose = FALSE)
}
