% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.lambda.R
\name{est.lambda}
\alias{est.lambda}
\title{Estimated Lambda}
\usage{
est.lambda(cv.fit, pihat, p, cov.num = 0)
}
\arguments{
\item{cv.fit}{An object of either class "cv.glmnet" from glmnet::cv.glmnet() or class "cv.ncvreg" from ncvreg::cv.ncvreg(), which is a list generated by a cross-validation fit.}

\item{pihat}{eatimated proprtion from HCTR::est.prop().}

\item{p}{Total number of variables, except for covariates.}

\item{cov.num}{Number of covariates in model, default is 0. Covariate matrix, W, is assumed on the left side of variable matrix, X. The column index of covariates are before those of variables.}
}
\value{
A list of (1) lambda.max, upper bound of new tuning region; (2) lambda.min, lower bound of new tuning region.
}
\description{
Estimate upper and lower bound of new tuning region of regularization parameter Lambda.
}
\examples{
set.seed(10)
X <- matrix(rnorm(20000), nrow = 100)
beta <- rep(0, 200)
beta[1:100] <- 5
Y <- MASS::mvrnorm(n = 1, mu = X\%*\%beta, Sigma = diag(100))
fit <- glmnet::cv.glmnet(x = X, y = Y)
pihat <- 0.01
result <- est.lambda(cv.fit = fit, pihat = pihat, p = ncol(X))
}
