% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_genres.R
\name{get_genres}
\alias{get_genres}
\title{Get Genres for Books from Goodreads}
\usage{
get_genres(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing book IDs.}
}
\value{
A named list where each element corresponds to a book ID and contains
a character vector of genres for that book.
}
\description{
This function reads book IDs from a file, fetches the corresponding Goodreads pages,
and extracts the genres for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the function
genres <- get_genres(temp_file)

# Display the results
print(genres)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
