% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kmultparallel.R
\name{print.parallel_Kmult}
\alias{print.parallel_Kmult}
\title{Print method for parallel_Kmult objects}
\usage{
\method{print}{parallel_Kmult}(x, ...)
}
\arguments{
\item{x}{An object of class 'parallel_Kmult' produced by
\code{\link{Kmultparallel}}}

\item{...}{Additional arguments (currently not used)}
}
\value{
Invisibly returns the input object
}
\description{
Provides a summary of Kmult analysis results showing the range of
Kmult values for each combination of dataset and treeset.
}
\examples{
\donttest{
# Create simple example data
library(phytools)
trees = replicate(3, pbtree(n = 20), simplify = FALSE)
class(trees) = "multiPhylo"
data = matrix(rnorm(20 * 4), nrow = 20, ncol = 4)
rownames(data) = trees[[1]]$tip.label

# Run analysis and print results
result = Kmultparallel(data, trees)
print(result)  # or simply: result
}

}
