% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getSizeOrd}
\alias{getSizeOrd}
\title{General Formulas for Sample Size Calculation}
\usage{
getSizeOrd(
  design = c("parallel", "crossover"),
  test = c("equality", "noninferiority", "superiority", "equivalence"),
  alpha = 0.05,
  beta = 0.2,
  varcatprob,
  k = 1,
  theta,
  delta = 0,
  rho = c(0.05, 0.07),
  r = 0.1
)
}
\arguments{
\item{design}{allocation method (\code{parallel} or \code{crossover}).}

\item{test}{four hypothesis tests: \code{equality}, \code{noninferiority}, \code{superiority}, and \code{equivalence}.}

\item{alpha}{level of significance.}

\item{beta}{type II error.}

\item{varcatprob}{list of two probability vectors per treatment arm}

\item{k}{ratio of control to treatment.}

\item{theta}{log odds ratio of outcome in treatment arm versus control arm}

\item{delta}{delta margin in test hypothesis.}

\item{rho}{vector of length 2, positive noncompliance rates of two arms.}

\item{r}{projected proportion of trial uniform loss of follow-up.}
}
\value{
sample size per arm.
}
\description{
This function computes the sample size required for two arms clinical trials with ordinal outcome measure. Four hypothesis tests are available under two allocation designs.
}
\examples{
# Ex 1. (n_trt=135, n_ctl=135)
getSizeOrd(design="parallel", test="equality", alpha=0.05, beta=0.10,
 varcatprob = list(c(0.2,0.5,0.2,0.1), c(0.378,0.472,0.106,0.044)),
 k=1, theta=0.887, delta=0, rho=c(0.05, 0.07), r=0.1)

# Ex 2. (Check back next version)
getSizeOrd(design="crossover", test="equality", alpha=0.05, beta=0.10,
 varcatprob = list(c(0.2,0.5,0.2,0.1), c(0.378,0.472,0.106,0.044)),
 k=1, theta=0.887, delta=0, rho=c(0.05, 0.07), r=0.1)

}
