% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{create_export_config}
\alias{create_export_config}
\title{Create an Export Configuration}
\usage{
create_export_config(
  file_name = NULL,
  width = NULL,
  height = NULL,
  dpi = 300,
  bg = "white",
  limitsize = FALSE
)
}
\arguments{
\item{file_name}{Character. Base name for exported files. Default: "gtap_plots".}

\item{width}{Numeric. Width of output in inches. Default: NULL (auto-calculated).}

\item{height}{Numeric. Height of output in inches. Default: NULL (auto-calculated).}

\item{dpi}{Numeric. Resolution for PNG export. Default: 300.}

\item{bg}{Character. Background color. Default: "white".}

\item{limitsize}{Logical. Whether to limit size. Default: FALSE.}
}
\value{
A list with export configuration parameters.
}
\description{
Creates a configuration list for controlling plot export settings.
This function provides auto-completion for export options.
}
\examples{
# Default export configuration
default_export <- create_export_config()

# Custom export configuration
custom_export <- create_export_config(
  file_name = "regional_impacts",
  width = 12,
  height = 8,
  dpi = 600
)
}
\author{
Pattawee Puangchit
}
