% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.lsn.type.matrix.R
\name{prep.lsn.type.matrix}
\alias{prep.lsn.type.matrix}
\title{Prepare Lesion Type Matrix}
\usage{
prep.lsn.type.matrix(ov.data, min.ngrp = 0)
}
\arguments{
\item{ov.data}{A list of six \code{data.frame} objects returned by the \code{\link{find.gene.lsn.overlaps}} function, containing gene-lesion overlap results.}

\item{min.ngrp}{Optional integer specifying the minimum number of patients that must be affected by any lesion in a given gene for that gene to be retained in the final matrix. The default is \code{0}, which includes all genes affected by any lesion in at least one patient.}
}
\value{
A character matrix where:
\itemize{
\item Rows correspond to genes (identified by Ensembl gene IDs).
\item Columns correspond to patient IDs.
\item Entries are \code{"none"}, a specific lesion type (e.g., \code{"gain"}, \code{"mutation"}), or \code{"multiple"}.
}
}
\description{
Constructs a matrix that summarizes the type(s) of lesions affecting each gene across patients. Each row represents a gene, and each column represents a patient.
}
\details{
This function produces a matrix with genes as rows and patients as columns. For each gene-patient pair:
\itemize{
\item If the patient has no lesion in the gene, the entry is \code{"none"}.
\item If the gene is affected by exactly one type of lesion in the patient (e.g., gain OR mutation), the entry is labeled with the corresponding lesion type.
\item If the gene is affected by more than one lesion type in the patient (e.g., gain AND mutation), the entry is labeled as \code{"multiple"}.
}

Genes affected in fewer than \code{min.ngrp} patients across all lesion types will be excluded if \code{min.ngrp > 0}.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)

# 1) Prepare gene and lesion data:
prep.gene.lsn <- prep.gene.lsn.data(lesion_data, hg38_gene_annotation)

# 2) Identify gene-lesion overlaps:
gene.lsn.overlap <- find.gene.lsn.overlaps(prep.gene.lsn)

# 3) Create lesion type matrix for genes affected in >= 5 patients:
lsn.type.mtx <- prep.lsn.type.matrix(gene.lsn.overlap, min.ngrp = 5)
}
\references{
Pounds, S., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{prep.gene.lsn.data}}, \code{\link{find.gene.lsn.overlaps}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
