% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp.functions6.R
\name{covMat}
\alias{covMat}
\alias{cov.pow.ex}
\alias{cov.rat.qu}
\alias{cov.matern}
\alias{cov.linear}
\title{Calculate a covariance matrix}
\usage{
cov.pow.ex(hyper, input, inputNew = NULL, gamma = 2)

cov.rat.qu(hyper, input, inputNew = NULL)

cov.matern(hyper, input, inputNew = NULL, nu)

cov.linear(hyper, input, inputNew = NULL)
}
\arguments{
\item{hyper}{The hyperparameters. It must be a list with certain names. See 
details.}

\item{input}{The covariate t. It must be either a matrix, where each column
represents a covariate, or a vector if there is only one covariate.}

\item{inputNew}{The covariate t'. It also must be a vector or a matrix. 
If NULL (default), 'inputNew' will be set to be equal to `input' and the 
function will return a squared, symmetric covariance matrix.}

\item{gamma}{Power parameter used in powered exponential kernel function. It
must be 0<gamma<=2. Default to 2, which gives the squared exponential 
covariance function.}

\item{nu}{Smoothness parameter of the Matern class. It must be a positive
value.}
}
\value{
A covariance matrix
}
\description{
Evaluates one of the following covariance functions at input 
vectors t and t': 
\itemize{
\item Powered exponential
\item Rational quadratic
\item Matern
\item Linear
}
}
\details{
The names for the hyperparameters should be: 
\itemize{
\item "pow.ex.v" and "pow.ex.w" (powered exponential);
\item "rat.qu.v", "rat.qu.w" and "rat.qu.a" (rational quadratic);
\item "matern.v" and "matern.w" (Matern);
\item "linear.i" and "linear.a" (linear);
\item "vv" (Gaussian white noise).
}
}
\references{
Shi, J. Q., and Choi, T. (2011), ``Gaussian Process Regression
  Analysis for Functional input'', CRC Press.
}
