% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose.theta.R
\name{choose.theta}
\alias{choose.theta}
\title{Heuristically chosen starting value of theta}
\usage{
choose.theta(u, m, no.scaling = FALSE, ...)
}
\arguments{
\item{u}{A matrix of (estimates of) realizations from the GMCM.}

\item{m}{The number of components to be fitted.}

\item{no.scaling}{Logical. If TRUE, no scaling of the means and
variance-covariance matrices is done.}

\item{\dots}{Arguments passed to \code{\link{kmeans}}.}
}
\value{
A list of parameters for the GMCM model on the form described in
  \code{\link{rtheta}}.
}
\description{
This function uses a \code{k}-means algorithm to heuristically select
suitable starting values for the general model.
}
\details{
The function selects the centers from the k-means algorithm as an initial
estimate of the means. The proportional sizes of the clusters are selected
as the initial values of the mixture proportions. The within cluster
standard deviations are squared and used as the variance of the clusters
within each dimension. The
correlations between each dimension are taken to be zero.
}
\note{
The function uses the \code{kmeans} function from the
  \code{stats}-package.
}
\examples{
set.seed(2)

# Simulating data
data1 <- SimulateGMCMData(n = 10000, m = 3, d = 2)
obs.data <- Uhat(data1$u)  # The ranked observed data

# Using choose.theta to get starting estimates
theta <- choose.theta(u = obs.data, m = 3)
print(theta)

# To illustrate theta, we can simulate from the model
data2 <- SimulateGMMData(n = 10000, theta = theta)

cols <- apply(get.prob(obs.data,theta),1,which.max)

# Plotting
par(mfrow = c(1,3))
plot(data1$z, main = "True latent GMM")
plot(Uhat(data1$u), col = cols,
     main = "Observed GMCM\\nColoured by k-means clustering")
plot(data2$z, main = "initial GMM")

# Alteratively, theta can simply be plotted to illustrate the GMM density
par(mfrow = c(1,1))
plot(theta, add.ellipses = TRUE)
points(data2$z, pch = 16, cex = 0.4)
}
\author{
Anders Ellern Bilgrau <anders.ellern.bilgrau@gmail.com>
}
