% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_suggest_fixes.R
\name{gg_suggest_fixes}
\alias{gg_suggest_fixes}
\title{Generate Code Suggestions to Fix Issues}
\usage{
gg_suggest_fixes(audit_report, auto_fix = FALSE, copy_to_clipboard = FALSE)
}
\arguments{
\item{audit_report}{An object returned by gg_audit(), or a ggplot2 object}

\item{auto_fix}{Logical. If TRUE, attempts to automatically apply fixes. Default is FALSE.}

\item{copy_to_clipboard}{Logical. If TRUE, copies suggested code to clipboard. Default is FALSE.}
}
\value{
If auto_fix is TRUE, returns a fixed ggplot2 object. Otherwise returns a list of code suggestions.
}
\description{
Takes an audit report and generates actionable R code to fix issues.
Can also attempt to automatically fix the plot.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(wt, mpg, color = factor(cyl))) +
  geom_point() +
  scale_color_manual(values = c("red", "green", "blue"))

# Get suggestions
gg_suggest_fixes(p)

# Auto-fix the plot
p_fixed <- gg_suggest_fixes(p, auto_fix = TRUE)
}
