% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalSF.R
\name{CalSF}
\alias{CalSF}
\title{SF calibration estimator}
\usage{
CalSF(ysA, ysB, pi_A, pi_B, pik_ab_B, pik_ba_A, domains_A, domains_B, N_A = NULL,
N_B = NULL, N_ab = NULL, xsAFrameA = NULL, xsBFrameA = NULL, xsAFrameB = NULL, 
xsBFrameB = NULL, xsT = NULL, XA = NULL, XB = NULL, X = NULL, met = "linear", 
conf_level = NULL)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable(s) of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable(s) of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{pik_ab_B}{A numeric vector of size \eqn{n_A} containing first order inclusion probabilities according to sampling desing in frame B for units belonging 
to overlap domain that have been selected in \eqn{s_A}.}

\item{pik_ba_A}{A numeric vector of size \eqn{n_B} containing first order inclusion probabilities according to sampling desing in frame A for units belonging 
to overlap domain that have been selected in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{N_A}{(Optional) A numeric value indicating the size of frame A}

\item{N_B}{(Optional) A numeric value indicating the size of frame B}

\item{N_ab}{(Optional) A numeric value indicating the size of the overlap domain}

\item{xsAFrameA}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_A}.}

\item{xsBFrameA}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_B}. For units in domain \eqn{b}, these values are 0.}

\item{xsAFrameB}{(Optional) A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_A}. For units in domain \eqn{a}, these values are 0.}

\item{xsBFrameB}{(Optional) A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_B}.}

\item{xsT}{(Optional) A numeric vector of length \eqn{n} or a numeric matrix or data frame of dimensions \eqn{n} x \eqn{m_T}, with \eqn{m_T} the number of auxiliary variables in both frames, containing auxiliary information for all units in the entire sample \eqn{s = s_A \cup s_B}.}

\item{XA}{(Optional) A numeric value or vector of length \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, indicating the population totals for the auxiliary variables considered in frame A.}

\item{XB}{(Optional) A numeric value or vector of length \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, indicating the population totals for the auxiliary variables considered in frame B.}

\item{X}{(Optional) A numeric value or vector of length \eqn{m_T}, with \eqn{m_T} the number of auxiliary variables in both frames, indicating the population totals for the auxiliary variables considered in both frames.}

\item{met}{(Optional) A character vector indicating the distance that must be used in calibration process. Possible values are "linear", "raking" and "logit". Default is "linear".}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
\code{CalSF} returns an object of class "EstimatorDF" which is a list with, at least, the following components:
 \item{Call}{the matched call.}
 \item{Est}{total and mean estimation for main variable(s).}
 \item{VarEst}{variance estimation for main variable(s).}
 If parameter \code{conf_level} is different from \code{NULL}, object includes component
 \item{ConfInt}{total and mean estimation and confidence intervals for main variables(s).}
 In addition, components \code{TotDomEst} and \code{MeanDomEst} are available when estimator is based on estimators of the domains. Component \code{Param} shows value of parameters involded in calculation of the estimator (if any).
 By default, only \code{Est} component (or \code{ConfInt} component, if parameter \code{conf_level} is different from \code{NULL}) is shown. It is possible to access to all the components of the objects by using function \code{summary}.
}
\description{
Produces estimates for population totals and means using the SF calibration estimator from survey data obtained
 from a dual frame sampling design. Confidence intervals are also computed, if required.
}
\details{
SF calibration estimator of population total is given by
 \deqn{\hat{Y}_{CalSF} = \hat{Y}_a + \hat{Y}_{ab} + \hat{Y}_b}
 where \eqn{\hat{Y}_a = \sum_{i \in s_a}\tilde{d}_i y_i, \hat{Y}_{ab} = \sum_{i \in (s_{ab} \cup s_{ba})}\tilde{d}_i y_i} 
 and \eqn{\hat{Y}_b = \sum_{i \in s_b} \tilde{d}_i y_i}, with \eqn{\tilde{d}_i} calibration weights which are calculated
 having into account a different set of constraints, depending on the case. For instance, if \eqn{N_A, N_B} and \eqn{N_{ab}} are known and no other auxiliary information is available, calibration constraints are
 \deqn{\sum_{i \in s_a}\tilde{d}_i = N_a, \sum_{i \in s_{ab} \cup s_{ba}}\tilde{d}_i = N_{ab}, \sum_{i \in s_{ba}}\tilde{d}_i = N_{ba}}

 Function covers following scenarios:
 \itemize{
\item There is not any additional auxiliary variable 
     \itemize{
     	\item \eqn{N_A, N_B} and \eqn{N_{ab}} unknown
	\item \eqn{N_{ab}} known and \eqn{N_A} and \eqn{N_B} unknown 
             \item \eqn{N_A} and \eqn{N_B} known and \eqn{N_{ab}} unknown
             \item \eqn{N_A, N_B} and \eqn{N_{ab}} known
     }
     \item At least, information about one additional auxiliary variable is available 
     \itemize{
	\item \eqn{N_{ab}} known and \eqn{N_A} and \eqn{N_B} unknown
             \item \eqn{N_A} and \eqn{N_B} known and \eqn{N_{ab}} unknown
             \item \eqn{N_A, N_B} and \eqn{N_{ab}} known
     }
 }

 To obtain an estimator of the variance for this estimator, one can use Deville's expression
 \deqn{\hat{V}(\hat{Y}_{CalSF}) = \frac{1}{1-\sum_{k\in s} a_k^2}\sum_{k\in s}(1-\pi_k)\left(\frac{e_k}{\pi_k} - \sum_{l\in s} a_{l} \frac{e_l}{\pi_l}\right)^2}
 where \eqn{a_k=(1-\pi_k)/\sum_{l\in s} (1-\pi_l)} and \eqn{e_k} are the residuals of the regression with auxiliary variables as regressors.
}
\examples{
data(DatA)
data(DatB)
data(PiklA)
data(PiklB)

#Let calculate SF calibration estimator for variable Clothing, without
#considering any auxiliary information
CalSF(DatA$Clo, DatB$Clo, PiklA, PiklB, DatA$ProbB, DatB$ProbA, 
DatA$Domain, DatB$Domain)

#Now, let calculate SF calibration estimator for variable Leisure when the frame
#sizes and the overlap domain size are known
CalSF(DatA$Lei, DatB$Lei, PiklA, PiklB, DatA$ProbB, DatB$ProbA, DatA$Domain, 
DatB$Domain, N_A = 1735, N_B = 1191, N_ab = 601)

#Finally, let calculate SF calibration estimator and a 90\% confidence interval
#for population total for variable Feeding, considering Income and Metres2 as auxiliary 
#variables and with frame sizes and overlap domain size known.
CalSF(DatA$Feed, DatB$Feed, PiklA, PiklB, DatA$ProbB, DatB$ProbA, DatA$Domain, 
DatB$Domain, N_A = 1735, N_B =  1191, N_ab = 601, xsAFrameA = DatA$Inc, 
xsBFrameA = DatB$Inc, xsAFrameB = DatA$M2, xsBFrameB = DatB$M2, 
XA = 4300260, XB = 176553, conf_level = 0.90)
}
\references{
Ranalli, M. G., Arcos, A., Rueda, M. and Teodoro, A. (2013)
 \emph{Calibration estimation in dual frame surveys}. arXiv:1312.0761 [stat.ME]

Deville, J. C., Sarndal, C. E. (1992)
 \emph{Calibration estimators in survey sampling.}
 Journal of the American Statistical Association, 87, 376 - 382
}
\seealso{
\code{\link{JackCalSF}}
}

