% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Udca_df}
\alias{Udca_df}
\title{Ursodeoxycholic Acid Trial Data}
\format{
A data frame with 1,360 observations and 8 variables:
\describe{
  \item{id}{Patient identifier (integer)}
  \item{trt}{Treatment group (integer)}
  \item{stage}{Disease stage (integer)}
  \item{bili}{Bilirubin level (numeric)}
  \item{riskscore}{Calculated risk score (numeric)}
  \item{futime}{Follow-up time in days (numeric)}
  \item{status}{Patient status indicator (numeric)}
  \item{endpoint}{Endpoint description (character)}
}
}
\source{
Data taken from the survival package version 3.8-3
}
\usage{
data(Udca_df)
}
\description{
This dataset, Udca_df, contains data from a clinical trial of ursodeoxycholic acid (UDCA).
The dataset includes 1,360 observations and 8 variables, covering treatment assignment,
disease stage, bilirubin levels, risk scores, follow-up time, and outcomes.
Some observations contain missing values.
}
\details{
The dataset name has been kept as 'Udca_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
