% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projmat.R
\name{occmat}
\alias{occmat}
\title{Matrices for the optimal coherent forecast combination}
\usage{
occmat(agg_mat, cons_mat, p = NULL, matNA = NULL,
       comb = "ols", res = NULL, approach = "proj", ...)
}
\arguments{
\item{agg_mat}{A (\eqn{n_u \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix, mapping the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_u} upper (constrained) variables.}

\item{cons_mat}{A (\eqn{n_u \times n}) numeric matrix representing the cross-sectional
zero constraints: each row represents a constraint equation, and each column represents
a variable. The matrix can be of full rank, meaning the rows are linearly independent,
but this is not a strict requirement, as the function allows for redundancy in the constraints.}

\item{p}{Total number of experts, \eqn{p}.}

\item{matNA}{A (\eqn{n \times p}) matrix consisting of 0s and 1s,
where each element indicates whether expert \eqn{j} (column) has
provided a forecast for variable \eqn{i} (row). If expert \eqn{j}
has provided a forecast for variable \eqn{i}, the corresponding
element \eqn{(i,j)} is 1; otherwise, it is 0.}

\item{comb}{A string specifying the reconciliation method. For details, see \link{cscov}.}

\item{res}{A list of \eqn{p} numeric (\eqn{N \times n}) matrix containing the
in-sample residuals. This input is used to compute some covariance matrices.}

\item{approach}{A string specifying the approach used to compute the reconciled
forecasts. Options include:
\itemize{
\item "\code{proj}" (\emph{default}): zero-constrained projection approach.
\item "\code{strc}": structural approach.
}}

\item{...}{Arguments passed on to \link{cscov}.}
}
\value{
A list of matrices:
\item{M}{Projection matrix.}
\item{Omega}{Matrix of the combination weights of the optimal linear multi-task forecast combination.}
\item{W}{Forecast error covariance matrix of the base forecasts.}
\item{Wc}{Forecast error covariance matrix of the combined forecasts.}
\item{Wtilde}{Forecast error covariance matrix of the reconciled combined forecasts.}
\item{K}{Matrix that replicates a vector (see Girolimetto and Di Fonzo, 2024).}
}
\description{
This function computes the matrices required for the optimal coherent
forecast combination \link{csocc}, as described in Girolimetto and Di Fonzo (2024).
These matrices serve as the foundation for building forecasts that effectively
combines the individual information from multiple experts while ensuring
coherence across the variables.
}
\references{
Girolimetto, D. and Di Fonzo, T. (2024), Coherent forecast combination for linearly
constrained multiple time series, \doi{10.48550/arXiv.2412.03429}.
}
\seealso{
Other Optimal combination: 
\code{\link{cscov}()},
\code{\link{csmtc}()},
\code{\link{csocc}()}
}
\concept{Optimal combination}
