% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cscov.R
\name{cscov}
\alias{cscov}
\alias{cscov.shrbe}
\alias{cscov.sambe}
\alias{cscov.shrbv}
\alias{cscov.sambv}
\title{Cross-sectional covariance matrix approximation}
\usage{
\method{cscov}{shrbe}(comb = "shrbe", ..., n = NULL, p = NULL, matNA = NULL,
      res = NULL, mse = TRUE, shrink_fun = NULL)

\method{cscov}{sambe}(comb = "sambe", ..., n = NULL, p = NULL, matNA = NULL,
      res = NULL, mse = TRUE)

\method{cscov}{shrbv}(comb = "shrbv", ..., n = NULL, p = NULL, matNA = NULL,
      res = NULL, mse = TRUE, shrink_fun = NULL)

\method{cscov}{sambv}(comb = "sambv", ..., n = NULL, p = NULL, matNA = NULL,
      res = NULL, mse = TRUE)
}
\arguments{
\item{comb}{A string specifying the reconciliation method.
\itemize{
\item \href{https://danigiro.github.io/FoReco/}{\code{FoReco}} approaches:
\code{"ols"}, \code{"wls"}, \code{"shr"}, \code{"sam"}.
\item "\code{shrbe}"/"\code{sambe}" - shrunk/sample block-diagonal covariance by experts.
\item "\code{shrbv}"/"\code{sambv}" - shrunk/sample block-diagonal covariance by variables.
}}

\item{...}{Arguments passed on to
\href{https://danigiro.github.io/FoReco/reference/cscov.html}{\code{FoReco::cscov}}.}

\item{n}{Total number of variables, \eqn{n}.}

\item{p}{Total number of experts, \eqn{p}.}

\item{matNA}{A (\eqn{n \times p}) matrix consisting of 0s and 1s,
where each element indicates whether expert \eqn{j} (column) has
provided a forecast for variable \eqn{i} (row). If expert \eqn{j}
has provided a forecast for variable \eqn{i}, the corresponding
element \eqn{(i,j)} is 1; otherwise, it is 0.}

\item{res}{A list of \eqn{p} numeric (\eqn{N \times n}) matrix containing the
in-sample residuals. This input is used to compute some covariance matrices.}

\item{mse}{If \code{TRUE} (\emph{default}) the residuals used to compute the covariance
matrix are not mean-corrected.}

\item{shrink_fun}{Shrinkage function of the covariance matrix,
\href{https://danigiro.github.io/FoReco/reference/shrink_estim.html}{\code{FoReco::shrink_estim}}
(\emph{default}).}
}
\value{
A (\eqn{m \times m}) symmetric positive (semi-)definite matrix, with
\eqn{m = \sum_{j = 1}^p n_j}, \eqn{n_j \leq n}.
}
\description{
Extended version of the
\href{https://danigiro.github.io/FoReco/reference/cscov.html}{\code{FoReco::cscov}}
function, introducing two new approximations for the covariance matrix
(both shrunk and sample versions). Specifically, \code{shrbe}/\code{sambe}
assume no correlation between experts, while \code{shrbv}/\code{sambv}
assume no correlation between variables.
}
\seealso{
Other Optimal combination: 
\code{\link{csmtc}()},
\code{\link{csocc}()},
\code{\link{occmat}()}
}
\concept{Optimal combination}
