# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' F2
#'
#' @param U IntegerVector with factor values corresponding to the patterns of Partially Identifying Variables (PIVs) observed among records in the concerned source
#' @param nvals integer for the total number of possible patterns (among all sources)
#'
#' @return List: for each pattern in value, count of the records having the pattern in the concerned source
#' @export
F2 <- function(U, nvals) {
    .Call(`_FlexRL_F2`, U, nvals)
}

#' F33
#'
#' @param A List with for each pattern in value, count of the records having the pattern in the concerned source
#' @param B List with for each pattern in value, count of the records having the pattern in the concerned source
#' @param nvals integer for the total number of possible patterns (among all sources)
#'
#' @return IntegerMatrix: nrow=nbr of potential links, ncol = 2, indicates the indices (of records from A, records from B) of records with matching patterns to be considered in the likelihood as potential links. It represents the cartesian product of both lists passed as parameters to represent all possible linked pairs of records.
#' @export
F33 <- function(A, B, nvals) {
    .Call(`_FlexRL_F33`, A, B, nvals)
}

#' sspaste2
#'
#' @param A IntegerMatrix with values to form patterns
#'
#' @return CharacterVector: "sspaste2(A)" is a faster version in Rcpp of "do.call(paste, c(as.data.frame(A), list(sep="_")))"
#' @export
sspaste2 <- function(A) {
    .Call(`_FlexRL_sspaste2`, A)
}

#' initDeltaMap
#'
#' @return void: Initialise the cpp map _DeltaMap representing the sparse linkage matrix Delta.
#' @export
initDeltaMap <- function() {
    invisible(.Call(`_FlexRL_initDeltaMap`))
}

#' Deltafind()
#'
#' @return IntegerMatrix: find the indices of the elements in the cpp map _DeltaMap representing the sparse linkage matrix Delta.
#' @export
Deltafind <- function() {
    .Call(`_FlexRL_Deltafind`)
}

#' sampleD
#'
#' @param S IntegerMatrix where each row correspond to the indices (from source A and source B) of records for which the true values matches (representing the potential links)
#' @param LLA NumericVector gives the likelihood contribution of each non linked record from A
#' @param LLB NumericVector gives the likelihood contribution of each non linked record from B
#' @param LLL NumericVector gives the likelihood contribution of each potential linked records (from select)
#' @param gamma NumericVector repeats the value of the parameter gamma (proportion of linked records) number of potential linked records (nrow of S) times
#' @param loglik double for the value of the current complete log likelihood of the model
#' @param nlinkrec integer for the current number of linked records
#' @param sumRowD A LogicalVector vector indicating, for each row of the linkage matrix, i.e. for each record in the smallest file A, whether the record has a link in B or not.
#' @param sumColD A LogicalVector vector indicating, for each column of the linkage matrix, i.e. for each record in the largest file B, whether the record has a link in A or not.
#'
#' @return
#' List:
#' - new set of links
#' - new sumRowD
#' - new sumColD
#' - new value of the complete log likelihood
#' - new number fo linked records
#' @export
sampleD <- function(S, LLA, LLB, LLL, gamma, loglik, nlinkrec, sumRowD, sumColD) {
    .Call(`_FlexRL_sampleD`, S, LLA, LLB, LLL, gamma, loglik, nlinkrec, sumRowD, sumColD)
}

#' sampleNL
#'
#' @param G IntegerVector of registered values for a certain Partially Identifying Variable (PIV) for non linked records
#' @param eta NumericVector parameter for the distribution of the PIV concerned
#' @param phi NumericVector parameter for the registration errors for the PIV concerned
#'
#' @return IntegerVector: of latent true values underlying G
#' @export
sampleNL <- function(G, eta, phi) {
    .Call(`_FlexRL_sampleNL`, G, eta, phi)
}

#' sampleNL
#'
#' @param GA IntegerVector of registered values for a certain Partially Identifying Variable (PIV) for linked records from A
#' @param GB IntegerVector of registered values for a certain PIV for linked records from B
#' @param survivalpSameH NumericVector of probabilities that the concerned PIV values coincide between file A and file B
#' @param choice_set IntegerMatrix of 2 columns (for A and for B) with possible joint true values underlying GA and GB
#' @param choice_equal IntegerVector of booleans indicating whether the 2 true values (from A and B) in the choice set are equal
#' @param nval integer for the number of unique values in the PIV concerned
#' @param phikA NumericVector parameter for the registration errors in A for the PIV concerned
#' @param phikB NumericVector parameter for the registration errors in B for the PIV concerned
#' @param eta NumericVector parameter for the distribution of the PIV concerned
#'
#' @return IntegerVector: of indices from the joint latent true values choice set underlying GA and GB
#' @export
sampleL <- function(GA, GB, survivalpSameH, choice_set, choice_equal, nval, phikA, phikB, eta) {
    .Call(`_FlexRL_sampleL`, GA, GB, survivalpSameH, choice_set, choice_equal, nval, phikA, phikB, eta)
}

#' cartesianProduct
#'
#' @param vec1 first IntegerVector of values to compute the cartesian product
#' @param vec2 second IntegerVector of values to compute the cartesian product
#'
#' @return IntegerMatrix: of 2 columns with the cartesian product of vec1 and vec2
#' @export
cartesianProduct <- function(vec1, vec2) {
    .Call(`_FlexRL_cartesianProduct`, vec1, vec2)
}

#' ExpandGrid
#'
#' @param vector1 first IntegerVector of values to compute the cartesian product
#' @param vector2 second IntegerVector of values to compute the cartesian product
#'
#' @return IntegerMatrix: of 2 columns with the cartesian product of vec1 and vec2
#' @export
ExpandGrid <- function(vector1, vector2) {
    .Call(`_FlexRL_ExpandGrid`, vector1, vector2)
}

#' generateSequence
#'
#' @param n integer superior to 1
#'
#' @return IntegerVector: with n values from 1 to n
#' @export
generateSequence <- function(n) {
    .Call(`_FlexRL_generateSequence`, n)
}

#' sampleH
#'
#' @param nA IntegerVector of dimensions of registered values of the Partially Identifying Variables (PIVs) in A
#' @param nB IntegerVector of dimensions of registered values of the PIVs in B
#' @param links IntegerMatrix of 2 columns with the indices of the linked records
#' @param survivalpSameH NumericMatrix with for each PIV the probability that true values coincide (if stable: filled with 1)
#' @param pivs_stable LogicalVector indicating for each PIV whether it is stable of not (if not we expect survivalpSameH for that same element to not be filled with 1 but with lower values)
#' @param pivsA List ith registered data from A
#' @param pivsB List with registered data from B
#' @param nvalues IntegerVector with number of unique values of each PIV
#' @param nonlinkedA LogicalVector indicating for all records in A whether they are linked or not
#' @param nonlinkedB LogicalVector indicating for all records in B whether they are linked or not
#' @param eta List parameters of the PIVs distributions
#' @param phi List parameters of the PIVs registration errors
#'
#' @return List:
#' - truePIVsA, true values underlying data in A
#' - truePIVsB, true values underlying data in B
#' @export
sampleH <- function(nA, nB, links, survivalpSameH, pivs_stable, pivsA, pivsB, nvalues, nonlinkedA, nonlinkedB, eta, phi) {
    .Call(`_FlexRL_sampleH`, nA, nB, links, survivalpSameH, pivs_stable, pivsA, pivsB, nvalues, nonlinkedA, nonlinkedB, eta, phi)
}

