% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fis.R
\docType{class}
\name{Fis}
\alias{Fis}
\title{Class "Fis"}
\description{
Class to manage a Fis "Fuzzy Inference System"
}
\section{Fields}{

\describe{
\item{\code{name}}{\link{character} vector, The name of the Fis}

\item{\code{conjunction}}{\link{character} vector, The conjunction operator of rules in the Fis\cr
Allowed values are: "min" (the default), "prod" or "luka"\cr}
}}

\section{Constructors}{

\describe{
\item{\code{Fis()}}{
The default constructor to build an empty Fis\cr
The Fis is initialized with "min" conjunction and empty name\cr
The design must be completed using the available functions to add inputs, outputs and rules before it can be used for inference
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{Fis} object}
}}

\item{\code{Fis(fis_file)}}{
The constructor to build a Fis from a configuration file\cr
The configuration file can be designed using the \href{https://www.fispro.org}{FisPro} open source software
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{fis_file}}{\link{character} vector, The filename of the Fis configuration file}
\item{return:}{\link{Fis} object}
}}}
}

\section{Methods}{

\describe{
\item{\code{input_size()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{integer} value, The number of inputs in the Fis}
}}

\item{\code{add_input(input)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{input}}{\link{FisIn} object, The input to add in the Fis}
}}

\item{\code{get_input(input_index)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{input_index}}{\link{integer} value, The index (1-based index) of the input in the Fis}
\item{return:}{\link{FisIn} object}
}}

\item{\code{get_inputs()}}{
Get all inputs in the Fis
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{list} of \link{FisIn} objects}
}}

\item{\code{output_size()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{integer} value, The number of outputs in the Fis}
}}

\item{\code{add_output(output)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{output}}{\link{FisOut} object, The output to add in the Fis}
}}

\item{\code{get_output(output_index)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{output_index}}{\link{integer} value, The index (1-based index) of the output in the Fis}
\item{return:}{\link{FisOut} object}
}}

\item{\code{get_outputs()}}{
Get all outputs in the Fis
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{list} of \link{FisOut} objects}
}}

\item{\code{rule_size()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{integer} value, The number of rules in the Fis}
}}

\item{\code{add_rule(rule)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{rule}}{\link{Rule} object, The rule to add in the Fis}
}}

\item{\code{get_rule(rule_index)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{rule_index}}{\link{integer} value, The index (1-based index) of the rule in the Fis}
\item{return:}{\link{Rule} object}
}}

\item{\code{get_rules()}}{
Get all rules in the Fis
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{list} of \link{Rule} objects}
}}

\item{\code{infer(data)}}{
Infers all outputs
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{data}}{\link{numeric} vector, \link{matrix} or \link{data.frame}, The input data or dataset to infer (the vector length or the number of columns must be equal to the number of inputs)}
\item{return:}{\link{numeric} vector or \link{matrix} (in case of 2D input data)}
}}

\item{\code{infer_output(data, output_index)}}{
Infers a single output
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{data}}{\link{numeric} vector, \link{matrix} or \link{data.frame}, The input data or dataset to infer (the vector length or the number of columns must be equal to the number of inputs)}
\item{argument: \code{output_index}}{\link{integer} value, The index (1-based index) of the output to infer}
\item{return:}{\link{numeric} value or vector (in case of 2D input data)}
}}}
}

\examples{
# build a Fis from a configuration file
fis_file <- system.file("extdata", "test.fis", package = "FisPro")
fis <- NewFis(fis_file)

# infers all outputs
inferred <- fis$infer(c(0.25, 0.75))

# infers first output
inferred_output1 <- fis$infer_output(c(0.25, 0.75), 1)

# infers second output
inferred_output2 <- fis$infer_output(c(0.25, 0.75), 2)

# infers test_data dataset
test_file <- system.file("extdata", "test_data.csv", package = "FisPro")
dataset <- read.csv(test_file)
inferred_dataset <- fis$infer(dataset)

########################################################################

# or build a Fis from scratch
fis <- NewFis()
fis$name <- "foo"

# build the first input
fisin1 <- NewFisIn(0, 1)
fisin1$name <- "input1"
fisin1$add_mf(NewMfTrapezoidalInf(0, 1))
fisin1$add_mf(NewMfTrapezoidalSup(0, 1))
fis$add_input(fisin1)

# build the second input
fisin2 <- NewFisIn(0, 1)
fisin2$name <- "input2"
fisin2$add_mf(NewMfTrapezoidalInf(0, 0.5))
fisin2$add_mf(NewMfTriangular(0, 0.5, 1))
fisin2$add_mf(NewMfTrapezoidalSup(0.5, 1))
fis$add_input(fisin2)

# build an output
fisout <- NewFisOutCrisp(0, 1)
fisout$name <- "output"
fis$add_output(fisout)

# add rules to the Fis
fis$add_rule(NewRule(c(1, 2), 0))
fis$add_rule(NewRule(c(2, 0), 1))
}
\seealso{
{
\link{NewFis}

\href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
