% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05.network&graph.R
\name{FF.net}
\alias{FF.net}
\title{Easily represent a firm-firm (FF) network using the package \code{network}}
\usage{
FF.net(x, aesthetic = c("simple", "nice"))
}
\arguments{
\item{x}{A matrix-like object produced by \code{\link{FF}} and related functions.}

\item{aesthetic}{Choose a pre-set for the network's look. Either \code{'simple'} or \code{'nice'} (see Details).}
}
\value{
A network in the desired format
}
\description{
Create an object of class \code{network} from the package \code{network} using a FF matrix of class \code{financial_matrix} using all the default aesthetic options
}
\details{
This function does not allow for any of the additional arguments that can be passed to \code{\link{FF.net.custom}}.
}
\section{Loops and values}{

Loops will be allowed if at least one of the matrix's diagonal entries is not zero.
The network will be valued if at least one entry of the matrix is neither zero nor one.

Instead, if \code{aesthetic} is set to \code{'simple'}:
\itemize{
 \item The width of the ties is \code{1};
 \item The colour of the ties is \code{#b4b4b4} (\href{https://www.color-name.com/hex/b4b4b4}{Philippine Silver});
 \item The size of the nodes is \code{5};
 \item The colour of the nodes is \code{#081677} (\href{https://www.color-name.com/gentian-blue.color}{Gentian blue}).
}

Otherwise, if \code{aesthetic} is set to \code{'nice'}:
\itemize{
 \item The width of the ties is \code{1};
 \item The colour of the ties is a grey scale reflecting tie strength if the network is valued, otherwise it is \code{#b4b4b4} (\href{https://www.color-name.com/hex/b4b4b4}{Philippine Silver});
 \item The size of the nodes reflects their \code{capitalisation} if all firms have data on it and ranges between \code{1} and \code{5}, otherwise it is \code{5} for all nodes;
 \item The colour of the nodes reflects their \code{sector} if all firms have data on it is taken from a built-in palette, otherwise it is \code{#081677} (\href{https://www.color-name.com/gentian-blue.color}{Gentian blue}).
}
}

\examples{
# Create a nice network representation of the binary FF of
# Berkshire Hataway's holdings based on common ownership
data("firms_BKB")
x <- FF.naive.ownership(firms_BKB)
FF.net(x = x, aesthetic = 'nice')

}
\seealso{
\link{FF.net.custom} \link{FF.graph} \link{FF.graph.custom}
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
