% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_fGARCH.R
\name{gof_fGARCH}
\alias{gof_fGARCH}
\title{Goodness-of-fit Test for Functional ARCH/GARCH Model}
\usage{
gof_fGARCH(f_data, M, model, H = 10, pplot = NULL, max_eval = 10000)
}
\arguments{
\item{f_data}{A \eqn{J \times N} matrix of functional time series data, where \eqn{J} is the number of discrete points in a grid and \eqn{N} is the sample size.}

\item{M}{A positive integer specifying the number of basis functions.}

\item{model}{A string to indicate which model will be estimated: "arch" - FARCH(1); "garch" - FGARCH(1,1).}

\item{H}{A positive integer specifying the maximum lag for which test statistics are computed.}

\item{pplot}{A Boolean value. If TRUE, the function will produce a plot of p-values of the test
as a function of maximum lag \eqn{H}, ranging from \eqn{H=1} to \eqn{H=20}, which may increase the computation time.}

\item{max_eval}{The maximum number of evaluations of the optimization function, used in the "arch" and "garch" tests.}
}
\value{
p-value.
}
\description{
It tests the goodness-of-fit of functional ARCH/GARCH models by accounting for the effect of functional GARCH parameter estimation.
}
\details{
It tests the goodness-of-fit of the fARCH(1) or fGARCH(1,1) models.
It fits the model to the input data and applies the test \eqn{M_{N,H}} in \code{\link{fport_wn}} to the model residuals.
The asymptotic distribution is adjusted to account for the estimation effect,
because the model residual depends on the joint asymptotics of the innovation process and
the estimated parameters. We assume that the kernel parameters are consistently estimated
by the Least Squares method proposed in Aue et al. (2017).
Then, the asymptotic distribution of the statistic \eqn{M_{N,H}} is given in Theorem 3.1
in Rice et al. (2020).
}
\examples{
\donttest{
# generate discrete evaluations of the FGARCH process.
set.seed(42)
yd = dgp.fgarch(J=50, N=200, type = "garch")$garch_mat

# test the adequacy of the FARCH(1) model.
gof_fGARCH(yd, M=2, model = "arch", H=10, pplot=TRUE)
}
}
\references{
[1] Aue, A., Horvath, L., F. Pellatt, D. (2017). Functional generalized autoregressive conditional heteroskedasticity. Journal of Time Series Analysis. 38(1), 3-21. <doi:10.1111/jtsa.12192>.\cr

[2] Rice, G., Wirjanto, T., Zhao, Y. (2020). Tests for conditional heteroscedasticity of functional data. Journal of Time Series Analysis. 41(6), 733-758. <doi:10.1111/jtsa.12532>.\cr
}
