% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psi.R
\name{psi}
\alias{psi}
\title{Fuzzy & Randomized Confidence Intervals}
\usage{
psi(method, distribution = "bernoulli", n = 1, sigma = 1)
}
\arguments{
\item{method}{numeric value or name of the method that defines how obtain confidence intervals.
\itemize{
 \item A numeric value utilizes the value as reference.
 \item "GM" utilize the Gayer-Meeden method.
 \item "AC" utilize the Agrest-Coull method (for the binomial distribution only).
 \item "SC" utilizes the score method (for the poisson distribution only).
}}

\item{distribution}{name of the distribution of the sample.
\itemize{
 \item "normal" for the normal distribution.
 \item "bernoulli" for the Bernoulli or binomial distribution.
 \item "poisson" for the Poisson distribution.
}}

\item{n}{sample size.}

\item{sigma}{standard deviation (for the case of normal distribution).}
}
\value{
A list containing the following information.
\describe{
 \item{[[1]]}{the membership function}
 \item{[[2]]}{distribution}
 \item{[[3]]}{n}
 \item{[[4]]}{method}
 \item{[[5]]}{sigma}
 \item{[[6]]}{the upper and lower bound function of the support of the membership function.}
}
}
\description{
Function to create "psi" type objects.
}
\examples{
x<-psi("GM",n=10)
x[[1]](0.3,2)
x[[2]]
x[[3]]
x[[4]]
x[[5]]
x[[6]](2)

x<-psi(0.5,n=10)
x[[1]](0.6,8)
x[[2]]
x[[3]]
x[[4]]
x[[5]]
x[[6]](8)
}
\references{
FELIX, Carlos Henrique Trigo Nasser, Garcia, Nancy Lopes & Sousa, Alex Rodrigo dos Santos. (2025). Uma Nova Abordagem para Construção de Intervalos de Confiança Aleatorizados (Master's thesis, Universidade Estadual de Campinas, Campinas).

GEYER, C. J.; MEEDEN, G. D. Fuzzy and randomized confidence intervals and
p-values. Statistical Science, v. 20, n. 4, p. 358–366, 2005. ISSN 08834237. Disponível em:
 http://www.jstor.org/stable/20061193.
}
