% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfkml.R
\name{dist.array}
\alias{dist.array}
\title{Compute Distance Array for Multidimensional Functional Data}
\usage{
dist.array(dt, time_scale, var_scales)
}
\arguments{
\item{dt}{A long-format data.frame containing the following columns in the specified order:
\itemize{
\item \code{ID}: An identifier for each trajectory.
\item \code{Time}: The time points at which measurements were recorded (numeric or integer vector).
\item \code{Variable1}, \code{Variable2}, ... : The measured variables over time (numeric values).
The data.frame should not include any missing values.
See 'Details' for structure requirements.
}}

\item{time_scale}{A single numeric value used to scale the \code{Time} column.
This ensures that time is appropriately weighted relative to the variables.}

\item{var_scales}{A numeric vector of scaling factors for the measured variables.
Its length must be equal to \code{ncol(dt) - 2}.}
}
\value{
A numeric value or matrix.
If \code{form = "scalar"}, returns the Fréchet distance between the two trajectories as a single numeric value.
If \code{form = "matrix"}, returns the dynamic programming matrix used to compute the distance.

A 3-dimensional array of pairwise distances with dimensions \code{[n, n, p]}, where:
\describe{
\item{n}{Number of unique trajectories.}
\item{p}{Number of variables.}
}
Each slice \code{[, , k]} is a distance matrix for variable \code{k}.
}
\description{
This function standardizes multidimensional functional data using provided scaling factors,
computes pairwise Fréchet distances between trajectories for each variable, and returns a
distance array (3-dimensional array of distance matrices).
}
\details{
The \code{dist.array} function first applies scaling to the \code{Time} and each measured variable.
Then, it computes pairwise Fréchet distances between trajectories for each variable separately.
The output is a 3-dimensional array in which each slice corresponds to a variable-specific distance matrix.

Unlike the \code{mfkml} function, which requires at least three measurements across time for each trajectory,
the SFKmL ((Sparse multi-dimensional Fréchet distance-based K-medoids for Longitudinal data), which uses \code{dist.array},
allows for trajectories with missing values, as long as each variable has at least three time points for each trajectory.
Therefore, \code{dt} may include missing values.
}
