% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{write_fft_df}
\alias{write_fft_df}
\title{Write an FFT definition to tree definitions}
\usage{
write_fft_df(fft, tree = -99L)
}
\arguments{
\item{fft}{One FFT definition
(as a data frame in tidy format, with one row per node).}

\item{tree}{The ID of the to-be-written FFT (as an integer).
Default: \code{tree = -99L}.}
}
\value{
An FFT definition in the one line
FFT definition format used by an \code{FFTrees} object
(as a data frame).
}
\description{
\code{write_fft_df} writes
the definition of a single FFT (as a tidy data frame)
into the one-line FFT definition used by an \code{FFTrees} object.

\code{write_fft_df} allows turning individual tree definitions
into the one-line FFT definition format
used by an \code{FFTrees} object.

\code{\link{read_fft_df}} provides the inverse functionality.
}
\seealso{
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{flip_exits}()},
\code{\link{get_fft_df}()},
\code{\link{read_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()}
}
\concept{tree definition and manipulation functions}
