% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamForceVector.R
\name{beamForceVector}
\alias{beamForceVector}
\title{beamForceVector}
\usage{
beamForceVector(beamP, fx, fy, NodeKnownL)
}
\arguments{
\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{fx}{Load vector (newtons) in the x-direction.}

\item{fy}{Load vector (newtons) in the y-direction.}

\item{NodeKnownL}{Data frame with constraint parameters applied to each node in the x and y directions. Formatted for use in reduced element matrix. Generated from ApplyBC function.}
}
\value{
Produces a matrix with loading parameters for each node.
\item{ReducedFV}{Reduced force vector matrix containing the model load parameters.}
}
\description{
Creates a matrix of loads for beams in the x & y direction for each load unconstrained node.
}
\examples{
data(beamGeo)
data(beamUDL)

NodeKnownL = beamBC
FV = beamForceVector(beamGeo$beamP, beamGeo$fx, beamGeo$fy, NodeKnownL)

}
