% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beamDimensions.R
\name{beamDimensions}
\alias{beamDimensions}
\title{beamDimensions}
\usage{
beamDimensions(Y, G, Nu, beamP, beamT, thick,  fx, fy)
}
\arguments{
\item{Y}{Elastic modulus value for material (Pa).}

\item{G}{Shear modulus value for material (Pa). If using Euler-Bernoulli model, G = 0.}

\item{Nu}{Poisson's ratio value for material.}

\item{beamP}{Matrix (2 x n) of beam coordinates.}

\item{beamT}{Matrix (2 x n) containing the number of the coordinate point as shown in beamP that connect to form a given beam (Discretization table).}

\item{thick}{Thickness of the beam}

\item{fx}{Load value (newtons) in the x direction.}

\item{fy}{Load value (newtons) in the y direction.}
}
\value{
Calculates values needed for both Timoshenko-Ehrenfest and Euler-Bernoulli beam theories.
\item{k}{Timoshenko-Ehrenfest correction}
\item{Length}{Beam length}
\item{Angle}{Beam angle within the plane}
\item{MomentofInertia}{Moment of Inertia for each beam}
\item{Displacement}{Displacement under Timoshenko-Ehernfest beam theory}
\item{RotationAngle}{Angle of rotation}
\item{StiffnessAngle}{Stiffness angle}
}
\description{
Calculates input dimensions needed for beam finite element.
}
\examples{
data(beamGeo)

DOF = 4
n = NROW(beamGeo$beamT)
thick = matrix(c(0.039149, 0.03, 0.0246625), ncol = 1, nrow = n) #height(thickness) of beam

beamDime = beamDimensions(beamGeo$Y, beamGeo$G, beamGeo$Nu, beamGeo$beamP, beamGeo$beamT,
                          beamGeo$thick, beamGeo$fx, beamGeo$fy)

}
