% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForceVector.2d.R
\name{ForceVector.2d}
\alias{ForceVector.2d}
\title{ForceVector.2d}
\usage{
ForceVector.2d(Fx, Fy, RSF, meshP, NodeKnownL)
}
\arguments{
\item{Fx}{Load vector for the x-direction}

\item{Fy}{Load vector for the y-direction}

\item{RSF}{If surface traction is present assign value as the ReducedSF matrix; if there is no surface traction set RSF = 0}

\item{meshP}{Matrix (2 x n) containing coordinate points of the mesh nodes.}

\item{NodeKnownL}{data frame with constraint parameters applied to each node in the x and y directions. Formatted for use in reduced element matrix. Generated from ApplyBC function.}
}
\value{
Produces a matrix with loading parameters for each node.
\item{ReducedFV}{Reduced force vector matrix containing the model load parameters.}
}
\description{
Creates a matrix of loads in the x & y direction for each load unconstrained node.
}
\examples{
data(triMesh)
data(reduc_SF)
data(bound)

meshP = triMesh$MeshPts$p
RSF = reduc_SF
Fx = 10
Fy = 10
NodeKnownL = bound

load = ForceVector.2d(Fx, Fy, RSF, meshP, NodeKnownL)

}
