#' Siganature matrix
#'
#' A dataset containing 547 genes and 22 TILs. 
#' 
#' @format A data frame with 547 rows and 22 variables:
#' \describe{
#'   \item{B.cells.naive}{naive B cells}
#'   \item{B.cells.memory}{memory B cells}
#'   \item{Plasma.cells}{Plasma cells}
#'   \item{T.cells.CD8}{CD8 T cells}
#'   \item{T.cells.CD4.naive}{naive CD4 T cells}
#'   \item{T.cells.CD4.memory.resting}{resting memory CD4 T cells}
#'   \item{T.cells.CD4.memory.activated}{activated memory CD4 T cells}
#'   \item{T.cells.follicular.helper}{follicular helper T cells }
#'   \item{T.cells.regulatory.Tregs.}{regulatory T cells}
#'   \item{T.cells.gamma.delta}{gamma delta T cells}
#'   \item{NK.cells.resting}{resting natural killer cells}
#'   \item{NK.cells.activated}{activated natural killer cells}
#'   \item{Monocytes}{monocytes}
#'   \item{Macrophages.M0}{M0 macrophages}
#'   \item{Macrophages.M1}{M1 macrophages}
#'   \item{Macrophages.M2}{M2 macrophages}
#'   \item{Dendritic.cells.resting}{resting dendritic cells}
#'   \item{Dendritic.cells.activated}{activated dendritic cells}
#'   \item{Mast.cells.resting}{resting mast cells}
#'   \item{Mast.cells.activated}{activated mast cells}
#'   \item{Eosinophils}{eosinophils}
#'   \item{Neutrophils}{neutrophils}
#' }
#' @references Aaron M. Newman, Chih Long Liu, Michael R. Green, Andrew J. Gentles, Weiguo Feng, Yue Xu, Chuong D. Hoang, Maximilian Diehn and Ash A. Alizadeh. Robust enumeration of cell subsets from tissue expression profiles. 
"LM22"

#' Gene-expression data from 14 follicular lymphoma patients
#'
#' This gene-expression dataset consists of surgical lymph node biopsies of 14 
#' follicular lymphoma patients with 19416 genes. It is available on Gene 
#' Expression Omnibus (GEO) with accession number GSE65135.
#' \url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE65135}. 
#' 
#' @format A data frame with 19416 rows and 14 variables:
#' \describe{
#'   \item{GSM1587831}{FL lymph node biopsy, untreated, 1063}
#'   \item{GSM1587832}{FL lymph node biopsy, untreated, 1080}
#'   \item{GSM1587833}{FL lymph node biopsy, untreated, 575}
#'   \item{GSM1587834}{FL lymph node biopsy, untreated, 581}
#'   \item{GSM1587835}{FL lymph node biopsy, untreated, 598}
#'   \item{GSM1587836}{FL lymph node biopsy, untreated, 639}
#'   \item{GSM1587837}{FL lymph node biopsy, untreated, 664}
#'   \item{GSM1587838}{FL lymph node biopsy, untreated, 666}
#'   \item{GSM1587839}{FL lymph node biopsy, untreated, 695}
#'   \item{GSM1587840}{FL lymph node biopsy, untreated, 706}
#'   \item{GSM1587841}{FL lymph node biopsy, untreated, 726}
#'   \item{GSM1587842}{FL lymph node biopsy, untreated, 731}
#'   \item{GSM1587843}{FL lymph node biopsy, untreated, 944}
#'   \item{GSM1587844}{FL lymph node biopsy, untreated, 959}
#' }
#' @references Aaron M. Newman, Chih Long Liu, Michael R. Green, Andrew J. Gentles, Weiguo Feng, Yue Xu, Chuong D. Hoang, Maximilian Diehn and Ash A. Alizadeh. Robust enumeration of cell subsets from tissue expression profiles. 
"mixture"

