% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sRNA_length_distribution.R
\name{srnapredata}
\alias{srnapredata}
\title{Length distribution of small RNAs (sRNAs)}
\usage{
srnapredata(sRNAseq, Group)
}
\arguments{
\item{sRNAseq}{Character. All sRNA sequences in vector format.}

\item{Group}{Character. Group name.}
}
\value{
A data frame. The output consists of three columns, i.e., length, frequency and group name.
}
\description{
Get the length distribution of sRNAs.
}
\examples{
#P1(B.napus)
B.napu_sRNA <- srnapredata(sRNAseq = P1_sRNA_seq, Group = "B.napus(AACC)")
#P2(B.rapa)
B.rapa_sRNA <- srnapredata(sRNAseq = P2_sRNA_seq, Group = "B.rapa(AA)")
#F1(B.napus X B.rapa)
B.nr_sRNA <- srnapredata(sRNAseq = F1_sRNA_seq, Group = "B.napus x B.rapa(AAAACC)")
#intergrate these data for length distribution plot
sRNA_data <- rbind(B.napu_sRNA, B.rapa_sRNA, B.nr_sRNA)
#output result
head(sRNA_data)
#  Length Frequency         Group
#1     15         8 B.napus(AACC)
#2     16         7 B.napus(AACC)
#3     17        13 B.napus(AACC)
#4     18        16 B.napus(AACC)
#5     19        25 B.napus(AACC)
#6     20        33 B.napus(AACC)
}
