% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_plot.R
\name{test_plot}
\alias{test_plot}
\title{Function to plot KM plot for time-to-event data in simulation}
\usage{
test_plot(test0, plot.index = 1)
}
\arguments{
\item{test0}{an object obtained from test_procedure}

\item{plot.index}{the index of simulation}
}
\value{
A KM plot for events in each arm
}
\description{
Plot KM plot for each arm at one realization
}
\examples{
\donttest{
fit1 <- list(model = "piecewise uniform",
             theta = -0.58, 
             vtheta=0, accrualTime =0)
fit2<-list()
fit2[[1]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(0.5,0,6.5,0,1), 
                  vtheta = matrix(0,5,5))
fit2[[2]] <- list(model = "weibull with cured population and delayed treatment", 
                 theta = c(0.5,0,6.5,46,0.65), 
                 vtheta = matrix(0,5,5))
fit3<-list()
fit3[[1]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(0.5,0,6.5,0,1), 
                  vtheta = matrix(0,5,5))
fit3[[2]] <- list(model = "weibull with cured population and delayed treatment", 
                  theta = c(0.5,0,6.5,0,1),
                  vtheta = matrix(0,5,5))
fit4 <- list(model = "exponential", 
                   theta =log(0.0003), 
                   vtheta=0)
                   
test1<-test_procedure(pilevel=0.9,nyears=4,enroll_fit=fit1,
                      dropout_fit=fit4,enroll_prior=fit1,event_prior_h0=fit3,
                      event_prior_ha=fit2,dropout_prior=NULL,
                      target_n=200,target_IA_d=40,
                      target_d=60,ialpha=0.016,falpha=0.0450,
                      lag=46,by_fitted_enroll=FALSE,
                      by_fitted_dropout=FALSE,treatment_label=c('a','b'),
                      ngroups=2,alloc=c(1,1),nreps=10, IA_included=TRUE)
test_plot(test1)
}
}
