% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.r
\name{crop}
\alias{crop}
\alias{crop,Epoch-method}
\title{Methods for Epoch class}
\usage{
crop(x, start, end, ...)

\S4method{crop}{Epoch}(x, start, end, checkTimeRange = TRUE)
}
\arguments{
\item{x}{An Epoch object}

\item{start}{Numeric value specifying start of new time range}

\item{end}{Numeric value specifying end of new time range}

\item{...}{Not used}

\item{checkTimeRange}{Logical, whether to check the validity of the time range. This includes checking if the time range is empty, if \code{start} is greater than \code{end}, and if \code{start} or \code{end} are out of bounds. Default is TRUE.}
}
\value{
clip the time range of the Epoch object
}
\description{
Truncating iEEG data to a specific time range.
}
\examples{
# Create an Epoch object
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

# crop the epoch
crop(epoch, start = 0.5, end = 1.5)

}
\seealso{
Other Epoch methods: 
\code{\link{coltimes}()},
\code{\link{plot,Epoch,missing-method}},
\code{\link{resample}()},
\code{\link{show,Epoch-method}}
}
\concept{Epoch methods}
